#!BPY

"""
Name: 'Volume dot filler'
Blender: 241
Group: 'Object'
Tooltip: 'Fills a closed volume with vertices'
"""

__author__ = "GFA-MAD"
__version__ = "1.0 04/09/06"

__bpydoc__ = """\
This script create a new object by filling a selected one with vertices.
It can take a long time to compute many dots.
The more the original mesh contains vertices, the best the script will
work but the longer it'll take to compute
"""



from Blender import *
import random
btn1=Draw.Create(100)
btn2=Draw.Create(1)

# classe pour la gestion des extremites.
class Bounds:
	minX=minY=minZ=1E12
	maxX=maxY=maxZ=-1E12
	
	# Calcul des extremites de l'objet
	def __init__(self,objet):
		verts=objet.getData().verts
		lx=ly=lz=[]
		for v in verts:
			lx.append(v.co[0])
			ly.append(v.co[1])
			lz.append(v.co[2])
		self.minX=min(lx)
		self.minY=min(ly)
		self.minZ=min(lz)
		self.maxX=max(lx)
		self.maxY=max(ly)
		self.maxZ=max(lz)
	# Valeur aleatoire sur limtes X
	def aleaX(self):
		return random.uniform(self.minX,self.maxX)
	def aleaY(self):
		return random.uniform(self.minY,self.maxY)
	def aleaZ(self):
		return random.uniform(self.minZ,self.maxZ)
			

# Gestion des evenements
def event(evt,val):
	# On quitte le script
	if evt==Draw.ESCKEY:
		Draw.Exit()
					
def gui():
	global btn1,btn2
	BGL.glClearColor(0.25,0.25,0.25,0)
	BGL.glClear(BGL.GL_COLOR_BUFFER_BIT)
	BGL.glColor3f(0.5,0.5,1)
	BGL.glRasterPos2i(10,100)
	Draw.Text("This script fills a selected mesh with vertices.A new object is created.")
	btn1=Draw.Number("Number",1,60,60,100,20,btn1.val,1,10000,"Number of vertices to create")
	btn2=Draw.PushButton("GO ",2,200,60,100,20,"Go !") 

def bEvent(evt):
	global btn1,btn2
	if evt==2:
		l=Object.GetSelected()
		if len(l)>0:
			o=l[0]
			if o.getType()=="Mesh":
				Window.DrawProgressBar(0,'')
				execute(o)
			else:
				Draw.PupMenu("Error:Must be a Mesh")
		else:
			Draw.PupMenu("Error:A Mesh must be selected")
				
	Draw.Redraw()				

		

# Retourne si un point est dans un objet

def inObject(px,py,pz,objet):
	# Transforme les coordonnees en un vecteur
	p1=Mathutils.Vector([px,py,pz])
	verts=objet.getData().verts
	
	dmin=1E12
	# On parcourt la liste de tous les vecteurs pour connaitre le plus proche de celui choisi
	for p2 in verts:
		d=(p2.co-p1).length
		if d<dmin:
			dmin=d
			vertMin=p2
	v1=vertMin.no 		# Vecteur 1=la normale
	v2=p1-vertMin.co	# Vecteur 2=point aleatoire-point du maillage le plus proche
	
	if Mathutils.DotVecs(v1,v2)>=0:
		return False
	else:
		return True
		
def execute(objet):

	# Etape 1: Recuperer les limites de l'objet selectionne
	# -----------------------------------------------------
	
	if objet.getType()=="Mesh":
		
		bound=Bounds(objet)
		
		# Etape 2: On cree le nouvel objet qui recevra les points
		# -------------------------------------------------------
		
		mesh=NMesh.New(objet.getName()+".dot")
		objetPoint=Object.New('Mesh',objet.getName()+".dot")
		
		ve=mesh.verts
		# Etape 3: On effectue une boucle pour ajouter un a un tous les points
		# --------------------------------------------------------------------
		while len(ve)<btn1.val:
	
			# Choix d'un point alatoire
			px=bound.aleaX()
			py=bound.aleaY()
			pz=bound.aleaZ()
			if inObject(px,py,pz,objet):
				ve.append(NMesh.Vert(px,py,pz))
				if (len(ve) % 10)==0: 
					Window.DrawProgressBar((len(ve)+0.0)/btn1.val,'Filling...')
					
				
		# Et enfin on colle les morceaux
		# mesh.update()
		objetPoint.link(mesh)
		Scene.GetCurrent().link(objetPoint)
		objetPoint.setMatrix(objet.getMatrix())
		Redraw()	

Draw.Register(gui,event,bEvent)

		
		
		
	
	
	